window.addEventListener("load", () => {
    sessionStorage.removeItem('dontShowFileOpenWarning');
});

// Function to create and show a custom modal dialog
function asyncCustomConfirm(message) {
    return new Promise((resolve) => {
        // Check if the user has opted out of seeing this dialog for this session
        const dontShowAgain = sessionStorage.getItem('dontShowFileOpenWarning') === 'true';
        if (dontShowAgain) {
            resolve(true); // Proceed as if the user confirmed
            return;
        }

        // Create the modal container
        const modal = document.createElement('div');
        modal.style.position = 'fixed';
        modal.style.top = '0';
        modal.style.left = '0';
        modal.style.width = '100%';
        modal.style.height = '100%';
        modal.style.backgroundColor = 'rgba(0, 0, 0, 0.5)';
        modal.style.display = 'flex';
        modal.style.justifyContent = 'center';
        modal.style.alignItems = 'center';
        modal.style.zIndex = '1000';
        modal.setAttribute('role', 'dialog');
        modal.setAttribute('aria-labelledby', 'modal-title');

        // Create the modal content
        const modalContent = document.createElement('div');
        modalContent.style.backgroundColor = '#fff';
        modalContent.style.padding = '30px';
        modalContent.style.borderRadius = '10px';
        modalContent.style.maxWidth = '500px';
        modalContent.style.width = '90%';
        modalContent.style.boxShadow = '0 2px 10px rgba(0, 0, 0, 0.1)';
        modalContent.style.fontFamily = 'Roboto, sans-serif';
        modalContent.style.fontSize = '15px';

        // Add the message
        const messageElement = document.createElement('p');
        messageElement.id = 'modal-title';
        messageElement.textContent = message;
        messageElement.style.whiteSpace = 'pre-wrap'; // Preserve line breaks
        messageElement.style.marginBottom = '20px';
        modalContent.appendChild(messageElement);

        // Add the "Don't show again" checkbox
        const checkboxContainer = document.createElement('div');
        checkboxContainer.style.display = 'flex';
        checkboxContainer.style.alignItems = 'center';
        checkboxContainer.style.marginBottom = '20px';

        const checkbox = document.createElement('input');
        checkbox.type = 'checkbox';
        checkbox.id = 'dontShowAgain';
        checkbox.style.marginRight = '10px';

        const checkboxLabel = document.createElement('label');
        checkboxLabel.htmlFor = 'dontShowAgain';
        checkboxLabel.textContent = "Don't show it again";
        checkboxLabel.style.fontSize = '14px';

        checkboxContainer.appendChild(checkbox);
        checkboxContainer.appendChild(checkboxLabel);
        modalContent.appendChild(checkboxContainer);

        // Add the buttons
        const buttonContainer = document.createElement('div');
        buttonContainer.style.display = 'flex';
        buttonContainer.style.justifyContent = 'flex-end';
        buttonContainer.style.gap = '10px';

        const okButton = document.createElement('button');
        okButton.textContent = 'Proceed';
        okButton.style.padding = '8px 16px';
        okButton.style.backgroundColor = '#1E90FF';
        okButton.style.color = '#fff';
        okButton.style.border = 'none';
        okButton.style.borderRadius = '10px';
        okButton.style.cursor = 'pointer';
        okButton.setAttribute('aria-label', 'Proceed');

        const cancelButton = document.createElement('button');
        cancelButton.textContent = 'Cancel';
        cancelButton.style.padding = '8px 16px';
        cancelButton.style.backgroundColor = '#D3D3D3';
        cancelButton.style.color = '#000';
        cancelButton.style.border = 'none';
        cancelButton.style.borderRadius = '10px';
        cancelButton.style.cursor = 'pointer';
        cancelButton.setAttribute('aria-label', 'Cancel');

        buttonContainer.appendChild(cancelButton);
        buttonContainer.appendChild(okButton);
        modalContent.appendChild(buttonContainer);

        modal.appendChild(modalContent);
        document.body.appendChild(modal);

        // Focus the OK button for accessibility
        okButton.focus();

        // Handle button clicks
        okButton.onclick = () => {
            // If the checkbox is checked, save the preference for this session
            if (checkbox.checked) {
                sessionStorage.setItem('dontShowFileOpenWarning', 'true');
            }
            document.body.removeChild(modal);
            resolve(true);
        };

        cancelButton.onclick = () => {
            document.body.removeChild(modal);
            resolve(false);
        };

        // Close the modal with the Escape key
        const handleKeydown = (event) => {
            if (event.key === 'Escape') {
                document.body.removeChild(modal);
                resolve(false);
                document.removeEventListener('keydown', handleKeydown);
            }
        };
        document.addEventListener('keydown', handleKeydown);

        // Allow tab navigation within the modal
        const focusableElements = modalContent.querySelectorAll('button, input');
        const firstFocusable = focusableElements[0];
        const lastFocusable = focusableElements[focusableElements.length - 1];

        modalContent.addEventListener('keydown', (event) => {
            if (event.key === 'Tab') {
                if (event.shiftKey) {
                    // Shift + Tab: If on the first element, move to the last
                    if (document.activeElement === firstFocusable) {
                        event.preventDefault();
                        lastFocusable.focus();
                    }
                } else {
                    // Tab: If on the last element, move to the first
                    if (document.activeElement === lastFocusable) {
                        event.preventDefault();
                        firstFocusable.focus();
                    }
                }
            }
        });
    });
}

// Add this function to handle safe file opening
function safeOpenFile(url) {
  // Extract the file name from the URL
  const urlParts = url.split('/');
  const fileName = decodeURIComponent(urlParts[urlParts.length - 1]) || 'unknown_file';

  // Create the confirmation message
  const message = `You are about to open or download a file ${fileName}:\n\n` +
                  `This file might open in a new tab if supported by your browser.\n\n` +
                  `Or it will likely be downloaded to your Downloads folder.\n\n` +
                  `Do you want to proceed?`;

  // Use the asyncCustomConfirm function to prompt the user
  return asyncCustomConfirm(message).then(userConfirmed => {
    if (userConfirmed) {
      return window.open(url, '_blank');
    }
    return null;
  });
}

function encodeFilename(filename) {
    const sName = filename.replace(/%/g, "%25");
    const forbidden = "#^{}`[]';,";
    let result = '';

    for (let i = 0; i < sName.length; i++) {
        const char = sName[i];
        if (forbidden.includes(char)) {
            const hex = char.charCodeAt(0).toString(16).toUpperCase().padStart(2, '0');
            result += '%' + hex;
        } else {
            result += char;
        }
    }
    return result;
}