@ECHO OFF
REM ##############################  Decrypt.bat  ###############################
REM # You can use this batch file to decrypt backup files using command-line.  #
REM # Just customize the "User Define Section" below with values for your      #
REM # decrypt action.                                                          #
REM ############################################################################

REM ####################  Start: User Defined Section  #########################

REM -------------------------------  SOURCE_DIR  -------------------------------
REM | The path to the [<backup set ID>/blocks] folder which contains           |
REM | the backup files that you want to decrypt.                               |
REM | This folder should located under backup destination physically.          |
REM | e.g. SET SOURCE_DIR="C:\john\backupdata\1498444438340\blocks"            |
REM |      where directory "C:\john\backupdata" is path of local destination   |
REM ----------------------------------------------------------------------------
SET SOURCE_DIR=""

REM ------------------------------  ENCRYPT_KEY  -------------------------------
REM | The encrypting key of the backup data.                                   |
REM | e.g. SET ENCRYPT_KEY="RU5DUllQVF9LRVk="                                  |
REM |                                                                          |
REM | You can leave this parameter blank if backup data is not encrypted.      |
REM ----------------------------------------------------------------------------
SET ENCRYPT_KEY=""

REM -------------------------------  DECRYPT_TO  -------------------------------
REM | Directory to where you want files to be decrypted                        |
REM | Use "\\\\" instead of "\\" when you specify a UNC path                   |
REM | e.g. SET DECRYPT_TO="C:\Temp"                                            |
REM ----------------------------------------------------------------------------
SET DECRYPT_TO=""

REM ------------------------------  DECRYPT_FROM  ------------------------------
REM | File/Directory on the backup data that you would like to decrypt         |
REM | e.g. SET DECRYPT_FROM="C:\Data"                                          |
REM ----------------------------------------------------------------------------
SET DECRYPT_FROM=""

REM -----------------------------  POINT_IN_TIME  ------------------------------
REM | The point-in-time snapshot (successful backup) that you want to decrypt  |
REM | from the backup data. Use "Current" for the latest backup snapshot       |
REM | e.g. SET POINT_IN_TIME="2006-10-04-12-57-13"                             |
REM |  or  SET POINT_IN_TIME="Current"                                         |
REM |                                                                          |
REM | The point in time should be one of the directory name under SOURCE_DIR   |
REM | unless you want to decrypt latest backup snapshot.                       |
REM ----------------------------------------------------------------------------
SET POINT_IN_TIME="Current"

REM ---------------------------  RESTORE_PERMISSION  ---------------------------
REM | set to "Y" if you want to restore file permissions                       |
REM | set to "N" if you do NOT want to restore file permissions                |
REM ----------------------------------------------------------------------------
SET RESTORE_PERMISSION="N"

REM ----------------------------  SKIP_INVALID_KEY  ----------------------------
REM | set to "Y" if you want to skip decrypt file with invalid key             |
REM | set to "N" if you want to prompt to input a correct key                  |
REM ----------------------------------------------------------------------------
SET SKIP_INVALID_KEY="N"

REM ------------------------------  SYNC_OPTION  -------------------------------
REM | Delete extra files                                                       |
REM | set to "Y" if you want to enable sync option                             |
REM | set to "N" if you do NOT want to enable sync option                      |
REM | set to "" to prompt for selection                                        |
REM ----------------------------------------------------------------------------
SET SYNC_OPTION="N"

REM -------------------------  REPLACE_EXISTING_FILE  --------------------------
REM | set to "--all" to replace all existing file(s) of the same filename      |
REM | set to "--none" to skip all existing file(s) with the same filename      |
REM | set to "" to prompt for selection                                        |
REM ----------------------------------------------------------------------------
SET REPLACE_EXISTING_FILE="--all"

REM ------------------------------  SETTING_HOME  ------------------------------
REM | Directory to your setting home. Log files will be located inside.        |
REM | Default to "C:\Users\USER\.obm" when not set.           |
REM | e.g. SET SETTING_HOME="C:\Users\John\.obm"              |
REM ----------------------------------------------------------------------------
SET SETTING_HOME=""

REM OPTION:
REM ---------------------------------  FILTER  ---------------------------------
REM | Filter out what files you want to decrypt                                |
REM | -Pattern=xxx-Type=yyy-Target=zzz                                         |
REM | where xxx is the filter pattern,                                         |
REM |       yyy is the filter type, whice can be one of the following:         |
REM |           [exact | exactMatchCase | contains | containsMatchCase|        |
REM |            startWith | startWithMatchCase | endWith | endWithMatchCase]  |
REM |       zzz is the filter target, which can be one of the following:       |
REM |           [toFile | toFileDir | toDir]                                   |
REM |                                                                          |
REM | e.g. SET FILTER="-Pattern=.txt-Type=exact-Target=toFile"                 |
REM ----------------------------------------------------------------------------
SET FILTER=""

REM --------------------------------  TEMP_DIR  --------------------------------
REM | Directory to where you want to store decrypt files temporarily           |
REM | Use "\\\\" instead of "\\" when you specify a UNC path                   |
REM | e.g. SET TEMP_DIR="C:\Temp"                                              |
REM ----------------------------------------------------------------------------
SET TEMP_DIR=""

REM -----------------------------  VERIFY_CHKSUM  ------------------------------
REM | set to "Y" if you want to verify in-file delta file checksum during      |
REM | decrypt                                                                  |
REM | set to "N" if you do NOT want to verify in-file delta file checksum      |
REM | during decrypt                                                           |
REM ----------------------------------------------------------------------------
SET VERIFY_CHKSUM="N"

REM ####################  END: User Defined Section  ###########################

SET APP_HOME=..
SET JAVA_HOME=%APP_HOME%\jvm
SET JAVA_EXE=%JAVA_HOME%\bin\bJW.exe
SET JAVA_LIB_PATH=-Djava.library.path=%APP_HOME%\bin
SET PATH=%JAVA_HOME%\bin;%PATH%
SET CLASSPATH=%APP_HOME%\bin;%APP_HOME%\bin\cb.jar

SET "DEP_LIB_PATH=X64"
SET INI_FILE=cb.ini
SETLOCAL enabledelayedexpansion
SET JAVA_OPTS=
for /f "tokens=* delims=" %%A in ('findstr /V /R "^[#]" "%INI_FILE%"') do (
  set "line=%%A"
  if not "!line!"=="" set JAVA_OPTS=!JAVA_OPTS! !line!
)

SET PATH=%CD%\%APP_HOME%\bin\%DEP_LIB_PATH%;%PATH%
SET JAVA_LIB_PATH=%JAVA_LIB_PATH%;%APP_HOME%\bin\%DEP_LIB_PATH%

REM #############################################################################
ECHO - 
ECHO APP_HOME=%APP_HOME%
ECHO SETTING_HOME=%SETTING_HOME%
ECHO JAVA_HOME=%JAVA_HOME%
ECHO JAVA_EXE=%JAVA_EXE%
ECHO JAVA_OPTS=%JAVA_OPTS%
ECHO JAVA_LIB_PATH=%JAVA_LIB_PATH%
ECHO PATH=%PATH%
ECHO CLASSPATH=%CLASSPATH%
ECHO - 

@ECHO ON
%JAVA_EXE% %JAVA_LIB_PATH% -cp %CLASSPATH% %JAVA_OPTS% Decrypt --to=%DECRYPT_TO% --from=%DECRYPT_FROM% --source-dir=%SOURCE_DIR% --key=%ENCRYPT_KEY% %REPLACE_EXISTING_FILE% --date=%POINT_IN_TIME% --set-permission=%RESTORE_PERMISSION% --skip-invalid-key=%SKIP_INVALID_KEY% --sync=%SYNC_OPTION% --filter=%FILTER% --temp-dir=%TEMP_DIR% --verify-delta-file-chksum=%VERIFY_CHKSUM% --app-home=%APP_HOME% --setting-home=%SETTING_HOME%
@ECHO OFF
CD %APP_HOME%
IF "%APP_HOME%"==".." PAUSE
@ECHO ON