@ECHO OFF
REM #######################  RunDataIntegrityCheck.bat  ########################
REM # You can use this batch to run any of your backup sets from the           #
REM # command line. Just customize the "User Defined Section" below with your  #
REM # values for your backup action.                                           #
REM ############################################################################

REM ######################  START: User Defined Section  #######################

REM ------------------------  SETTING_HOME (Optional)  -------------------------
REM | Directory to your setting home. Default to                               |
REM | "C:\Users\USER\.obm" when not set.                                       |
REM | e.g. SET SETTING_HOME="C:\Users\John\.obm"                               |
REM ----------------------------------------------------------------------------
SET SETTING_HOME=""

REM -------------------------------  BACKUP_SET  -------------------------------
REM | The name or ID of the backup set that you want to run.                   |
REM | If backup set name is not in English, please use ID instead.             |
REM | e.g. SET BACKUP_SET="1119083740107"                                      |
REM |  or  SET BACKUP_SET="FileBackupSet-1"                                    |
REM | You can use "ALL" to run data integrity check for all backup sets.       |
REM | i.e. SET BACKUP_SET="ALL"                                                |
REM |                                                                          |
REM | You can leave this parameter blank if you have only 1 backup set.        |
REM ----------------------------------------------------------------------------
SET BACKUP_SET="ALL"

REM -----------------------------  BACKUP_DEST  --------------------------------
REM | The name or ID of the backup destination that you want to run.           |
REM | If backup destination name is not in English, please use ID instead.     |
REM | e.g. SET BACKUP_DEST="1740107119083"                                     |
REM |  or  SET BACKUP_DEST="Destination-1"                                     |
REM | You can use "ALL" to run data integrity check for all destinations.      |
REM | i.e. SET BACKUP_DEST="ALL"                                               |
REM |                                                                          |
REM | You can leave this parameter blank if you have only 1 destination.       |
REM | Remark: This option is ignored if BACKUP_SET="ALL"                       |
REM ----------------------------------------------------------------------------
SET BACKUP_DEST="ALL"

REM --------------------------------  CRC_MODE  --------------------------------
REM | You can run Cyclic Redundancy Check (CRC) during data integrity check    |
REM | Options available: ENABLE-CRC/DISABLE-CRC                                |
REM | i.e. SET CRC_MODE="ENABLE-CRC"                                           |
REM |  or  SET CRC_MODE="DISABLE-CRC"                                          |
REM ----------------------------------------------------------------------------
SET CRC_MODE="DISABLE-CRC"

REM ------------------------------  REBUILD_MODE  ------------------------------
REM | You can run rebuild index                                                |
REM | Options available: ENABLE-REBUILD/DISABLE-REBUILD                        |
REM | i.e. SET REBUILD_MODE="ENABLE-REBUILD"                                   |
REM |  or  SET REBUILD_MODE="DISABLE-REBUILD"                                  |
REM ----------------------------------------------------------------------------
SET REBUILD_MODE="DISABLE-REBUILD"

REM ----------------------  CLEANUP_RECYCLE_BIN_MODE  --------------------------
REM | You can enforce to clean up recycle bin during data integrity check.     |
REM | If this option is enabled, it will override retention period in recycle  |
REM | bin settings and delete all files inside, no matter when those files     |
REM | were moved to recycle bin                                                |
REM | Options available:                                                       |
REM | ENABLE-CLEANUP-RECYCLE-BIN/DISABLE-CLEANUP-RECYCLE-BIN                   |
REM | i.e. SET CLEANUP_RECYCLE_BIN_MODE="ENABLE-CLEANUP-RECYCLE-BIN"           |
REM |  or  SET CLEANUP_RECYCLE_BIN_MODE="DISABLE-CLEANUP-RECYCLE-BIN"          |
REM ----------------------------------------------------------------------------
SET CLEANUP_RECYCLE_BIN_MODE="DISABLE-CLEANUP-RECYCLE-BIN"

REM -----------------------------  PASSCODE_2FA  -------------------------------
REM | If 2FA is enabled for the user, TOTP passcode need to be verified before |
REM | running integrity check. If 2FA is not enabled, please left this blank.  |
REM | e.g. PASSCODE_2FA="123456"                                               |
REM |  or  PASSCODE_2FA=""                                                     |
REM ----------------------------------------------------------------------------
SET PASSCODE_2FA=""

REM #######################  END: User Defined Section  ########################

SET APP_HOME=..
SET JAVA_HOME=%APP_HOME%\jvm
SET JAVA_EXE=%JAVA_HOME%\bin\bJW.exe
SET JAVA_LIB_PATH=-Djava.library.path=%APP_HOME%\bin
SET PATH=%JAVA_HOME%\bin;%PATH%
SET CLASSPATH=%APP_HOME%\bin;%APP_HOME%\bin\cb.jar

SET "DEP_LIB_PATH=X64"
SET INI_FILE=cb.ini
SETLOCAL enabledelayedexpansion
SET JAVA_OPTS=
for /f "tokens=* delims=" %%A in ('findstr /V /R "^[#]" "%INI_FILE%"') do (
  set "line=%%A"
  if not "!line!"=="" set JAVA_OPTS=!JAVA_OPTS! !line!
)

SET PATH=%CD%\%APP_HOME%\bin\%DEP_LIB_PATH%;%PATH%
SET JAVA_LIB_PATH=%JAVA_LIB_PATH%;%APP_HOME%\bin\%DEP_LIB_PATH%

REM #############################################################################
ECHO - 
ECHO APP_HOME=%APP_HOME%
ECHO SETTING_HOME=%SETTING_HOME%
ECHO JAVA_HOME=%JAVA_HOME%
ECHO JAVA_EXE=%JAVA_EXE%
ECHO JAVA_OPTS=%JAVA_OPTS%
ECHO JAVA_LIB_PATH=%JAVA_LIB_PATH%
ECHO PATH=%PATH%
ECHO CLASSPATH=%CLASSPATH%
ECHO - 

ECHO Running data integrity check for backup set - '%BACKUP_SET%', destination - '%BACKUP_DEST%' ...
@ECHO ON
%JAVA_EXE% %JAVA_LIB_PATH% -cp %CLASSPATH% %JAVA_OPTS% RunDataIntegrityCheck %APP_HOME% %SETTING_HOME% %BACKUP_SET% %BACKUP_DEST% %CRC_MODE% %REBUILD_MODE% %CLEANUP_RECYCLE_BIN_MODE% %PASSCODE_2FA%
@ECHO OFF
CD %APP_HOME%
IF "%APP_HOME%"==".." PAUSE
@ECHO ON
