@ECHO OFF
SETLOCAL
SETLOCAL ENABLEDELAYEDEXPANSION
CLS
REM ################################################################
REM # You can use this batch to parse out all related              #
REM # directory objects by user from a .ldf file                   #
REM # and import those directory objects to Active Directory       #
REM # (and recursively process for all its owner gropus)           #
REM #                                                              #
REM # Last Updated: 2012-12-11                                     #
REM ################################################################

REM //Create variables
CALL :main_initial

REM //Parse input paraments
FOR %%i IN (%*) DO CALL :main_parseArgument %%i
IF %VAR_MAIN_PINFO% LSS 0 (
  CALL :main_printHelp
  GOTO main_exit
)

IF "%VAR_MAIN_HOSTNAME%"=="" (
  REM //Get computer hostname
  FOR /F "usebackq tokens=* delims=" %%i IN (`dsquery server -o rdn 2^>^&1`) DO SET "VAR_MAIN_HOSTNAME=%%i"
)

IF %VAR_MAIN_DEBUG% GTR 0  CALL :main_printConfig

IF NOT EXIST "%VAR_MAIN_EXEC_IMPORT%" (
  ECHO.Missing batch file "%VAR_MAIN_EXEC_IMPORT%"...
  ECHO.Process terminated...
  GOTO main_exit
)

REM //Check source file exist
IF NOT EXIST "%VAR_MAIN_FILE_IN%" (
  ECHO.File "%VAR_MAIN_FILE_IN%" not found
  GOTO main_exit
)

REM //Generate index file
IF %VAR_MAIN_DEBUG% LEQ 0 IF EXIST "%VAR_MAIN_FILE_LST%" CALL :main_removeFile "%VAR_MAIN_FILE_LST%"
IF NOT EXIST "%VAR_MAIN_FILE_LST%" (
  ECHO.^>^>^> Indexing source file...
  ECHO.
  CALL :index_main "%VAR_MAIN_FILE_IN%" "%VAR_MAIN_FILE_LST%" %VAR_MAIN_VERBOSE%
  ECHO.
  CLS
)

REM //Get user index count
FOR /F "usebackq tokens=*" %%a IN (`FIND /C ",idx," "%VAR_MAIN_FILE_LST%" 2^>^&1`) DO (
  CALL :main_findNumber "%%a"
  SET "VAR_MAIN_LSTMAX=!VAR_MAIN_RTN_TMP!"
)

REM //Show main menu
:main_mainMenu
CALL :main_printMenu
REM //Read user input
SET /P "VAR_MAIN_CMD=>"

REM //Exit
IF "%VAR_MAIN_CMD%"=="Q" SET "VAR_MAIN_CMD=q"
IF "%VAR_MAIN_CMD%"=="q" GOTO main_exit
REM //List user index
IF "%VAR_MAIN_CMD%"=="S" SET "VAR_MAIN_CMD=s"
IF "%VAR_MAIN_CMD%"=="s" (
  CALL :main_printList !VAR_MAIN_LSTST! %VAR_MAIN_PAGE%
  GOTO main_listMenu
)
REM //Import user by index
IF "%VAR_MAIN_CMD%"=="I" SET "VAR_MAIN_CMD=i"
IF "%VAR_MAIN_CMD%"=="i" (
  SET "VAR_MAIN_FLAG=0"
  ECHO.User index number:
  SET /P "VAR_MAIN_CMD=>"
  REM //Check leading zero
  SET "VAR_MAIN_NUM=!VAR_MAIN_CMD:~0,1!"
  IF !VAR_MAIN_NUM! LEQ 0 GOTO main_main_importByIndex_end
  REM //Cast to number
  SET /A VAR_MAIN_NUM=!VAR_MAIN_CMD!"
  IF !VAR_MAIN_NUM! LEQ 0 GOTO main_main_importByIndex_end
  FOR /F "usebackq tokens=1,2,3,* delims=," %%a IN (`FIND " !VAR_MAIN_NUM!,idx," "%VAR_MAIN_FILE_LST%" 2^>^&1`) DO (
    IF "%%b"=="idx" (
      IF "%%c" == "h" (
        CALL :importUsr_main "%VAR_MAIN_FILE_IN%" "%VAR_MAIN_FILE_LST%" "" "%%d" "%VAR_MAIN_HOSTNAME%" %VAR_MAIN_VERBOSE%
      ) ELSE (
        CALL :importUsr_main "%VAR_MAIN_FILE_IN%" "%VAR_MAIN_FILE_LST%" "%%d" "" "%VAR_MAIN_HOSTNAME%" %VAR_MAIN_VERBOSE%
      )
      SET "VAR_MAIN_FLAG=1"
      GOTO main_main_importByIndex_end
    )
  )
:main_main_importByIndex_end
  IF !VAR_MAIN_FLAG! LEQ 0 ECHO.Invalid index...
)
REM //Import user by name
IF "%VAR_MAIN_CMD%"=="N" SET "VAR_MAIN_CMD=n"
IF "%VAR_MAIN_CMD%"=="n" (
  ECHO.User name:
  SET /P "VAR_MAIN_CMD=>"
  CALL :importUsr_main "%VAR_MAIN_FILE_IN%" "%VAR_MAIN_FILE_LST%" "!VAR_MAIN_CMD!" "" "%VAR_MAIN_HOSTNAME%" %VAR_MAIN_VERBOSE%
)
REM //Import user from file
IF "%VAR_MAIN_CMD%"=="F" SET "VAR_MAIN_CMD=f"
  IF "%VAR_MAIN_CMD%"=="f" (
    ECHO.file name:
    SET /P "VAR_MAIN_CMD=>"
    IF EXIST !VAR_MAIN_CMD! (
      FOR /F "usebackq tokens=1,* delims=:" %%a IN ("!VAR_MAIN_CMD!") DO (
      CALL :importUsr_main "%VAR_MAIN_FILE_IN%" "%VAR_MAIN_FILE_LST%" "%%b" "" "%VAR_MAIN_HOSTNAME%" %VAR_MAIN_VERBOSE%
    )
  ) ELSE (
    ECHO.File "!VAR_MAIN_CMD!" not found
  )
)
ECHO.
GOTO main_mainMenu

REM //Show user list
:main_listMenu
REM //Read user input
SET /P "VAR_MAIN_CMD=>"

REM //Exit
IF "%VAR_MAIN_CMD%"=="Q" SET "VAR_MAIN_CMD=q"
IF "%VAR_MAIN_CMD%"=="q" GOTO main_exit
REM //Back
IF "%VAR_MAIN_CMD%"=="B" SET "VAR_MAIN_CMD=b"
IF "%VAR_MAIN_CMD%"=="b" GOTO main_mainMenu
REM //Previous
IF "%VAR_MAIN_CMD%"=="P" SET "VAR_MAIN_CMD=p"
IF "%VAR_MAIN_CMD%"=="p" (
  SET /A VAR_MAIN_NUM=%VAR_MAIN_LSTST%-%VAR_MAIN_PAGE%
  CALL :main_printList !VAR_MAIN_NUM! %VAR_MAIN_PAGE%
)
REM //Next
IF "%VAR_MAIN_CMD%"=="N" SET "VAR_MAIN_CMD=n"
IF "%VAR_MAIN_CMD%"=="n" (
  SET /A VAR_MAIN_NUM=%VAR_MAIN_LSTST%+%VAR_MAIN_PAGE%
  CALL :main_printList !VAR_MAIN_NUM! %VAR_MAIN_PAGE%
)
REM //Jump
IF "%VAR_MAIN_CMD%"=="J" SET "VAR_MAIN_CMD=j"
IF "%VAR_MAIN_CMD%"=="j" (
  SET "VAR_MAIN_FLAG=0"
  ECHO.Page number:
  SET /P "VAR_MAIN_CMD=>"
  REM //Check leading zero
  SET "VAR_MAIN_NUM=!VAR_MAIN_CMD:~0,1!"
  IF !VAR_MAIN_NUM! LEQ 0 GOTO main_listMenuJump_end
  REM //Cast to number
  SET /A VAR_MAIN_NUM=!VAR_MAIN_CMD!"
  IF !VAR_MAIN_NUM! LEQ 0 GOTO main_listMenuJump_end
  
  IF !VAR_MAIN_NUM! LEQ 1 SET /A VAR_MAIN_NUM=1
  SET /A VAR_MAIN_NUM-=1
  SET /A VAR_MAIN_NUM*=%VAR_MAIN_PAGE%
  IF !VAR_MAIN_NUM! GTR %VAR_MAIN_LSTMAX% (
    SET /A VAR_MAIN_NUM=%VAR_MAIN_LSTMAX%/%VAR_MAIN_PAGE%
    SET /A VAR_MAIN_NUM*=%VAR_MAIN_PAGE%
  )
  SET /A VAR_MAIN_NUM+=1
  CALL :main_printList !VAR_MAIN_NUM! %VAR_MAIN_PAGE%
  SET "VAR_MAIN_FLAG=1"
:main_listMenuJump_end
  IF !VAR_MAIN_FLAG! LEQ 0 ECHO.Invalid index...
)
GOTO main_listMenu

REM //Exit point
:main_exit
ECHO.
ECHO.Done!

REM //Delete temp file
IF %VAR_MAIN_DEBUG% LEQ 0 CALL :main_removeFile "%VAR_MAIN_FILE_LST%"

REM //Delete variables
CALL :main_deInitial

ENDLOCAL
GOTO :eof


REM //Main----------------------------------------------------------
REM //Sub-routine to initial variables
REM //In:
REM //Out:
:main_initial
REM //User argument
SET "VAR_MAIN_FILE_IN=fExport.ldf"
SET "VAR_MAIN_HOSTNAME="
SET "VAR_MAIN_VERBOSE=0"
SET "VAR_MAIN_PINFO=0"
SET "VAR_MAIN_PAGE=20"
SET "VAR_MAIN_DEBUG=0"
REM //Temp file
SET "VAR_MAIN_FILE_LST=fExport.idx"
REM //External file
SET "VAR_MAIN_EXEC_IMPORT=RunADImport.bat"
REM //Internal data
SET "VAR_MAIN_FLAG="
SET "VAR_MAIN_NUM="
SET "VAR_MAIN_LSTST=1"
SET "VAR_MAIN_LSTEN=0"
SET "VAR_MAIN_LSTMAX=0"
SET "VAR_MAIN_CMD="
SET "VAR_MAIN_BASE64DEC="
SET "VAR_MAIN_IS_BASE64DEC="
SET "VAR_MAIN_HEXDUMP="
SET "VAR_MAIN_RTN_TMP="
GOTO :eof

REM //Sub-routine to de-initial variables
REM //In:
REM //Out:
:main_deInitial
SET "VAR_MAIN_FILE_IN="
SET "VAR_MAIN_HOSTNAME="
SET "VAR_MAIN_VERBOSE="
SET "VAR_MAIN_PINFO="
SET "VAR_MAIN_PAGE="
SET "VAR_MAIN_DEBUG="
SET "VAR_MAIN_FILE_LST="
SET "VAR_MAIN_EXEC_IMPORT="
SET "VAR_MAIN_FLAG="
SET "VAR_MAIN_NUM="
SET "VAR_MAIN_LSTST="
SET "VAR_MAIN_LSTEN="
SET "VAR_MAIN_LSTMAX="
SET "VAR_MAIN_CMD="
SET "VAR_MAIN_BASE64DEC="
SET "VAR_MAIN_IS_BASE64DEC="
SET "VAR_MAIN_HEXDUMP="
SET "VAR_MAIN_RTN_TMP="
GOTO :eof

REM //Sub-routine to print help message
:main_printHelp
REM //In:
REM //Out:
ECHO.----------------------------------------------------------------
ECHO.Input arguments:
ECHO.     fin:[input file]
ECHO.     index:[number]
ECHO.     verbose:[0/1]
ECHO.     help
ECHO.
ECHO. (Use double quotation marks the argument
ECHO.  if it contains any space char eg."argu ment")
ECHO.
ECHO.  fin - .ldf source file
ECHO.  index - number of user index show per page
ECHO.  verbose - level of information show
ECHO.
GOTO :eof

REM //Sub-routine to print current config
REM //In:
REM //Out:
:main_printConfig
ECHO.Current config:
ECHO.     input file: %VAR_MAIN_FILE_IN%
ECHO.     index per page: %VAR_MAIN_PAGE%
ECHO.     hostname: %VAR_MAIN_HOSTNAME%
ECHO.
GOTO :eof

REM //Sub-routine to parse input paraments
REM //In: [argument]
REM //Out:
:main_parseArgument
IF %VAR_MAIN_PINFO% LSS 0 GOTO main_parseArgument_exit
SET "VAR_MAIN_FLAG=0"
FOR /F "tokens=1,* delims=:" %%i IN ("%~1") DO (
  IF /I "%%i"=="FIN" SET "VAR_MAIN_FILE_IN=%%j" & SET "VAR_MAIN_FLAG=1"
  IF /I "%%i"=="INDEX" SET "VAR_MAIN_PAGE=%%j" & SET "VAR_MAIN_FLAG=1"
  IF /I "%%i"=="VERBOSE" SET "VAR_MAIN_VERBOSE=%%j" & SET "VAR_MAIN_FLAG=1"
  IF /I "%%i"=="INFO" SET "VAR_MAIN_PINFO=%%j" & SET "VAR_MAIN_FLAG=1"
  IF /I "%%i"=="DEBUG" SET "VAR_MAIN_DEBUG=%%j" & SET "VAR_MAIN_FLAG=1"

  REM //Default
  IF /I "%%j"=="" SET "VAR_MAIN_PINFO=-1"
  IF !VAR_MAIN_FLAG! LEQ 0 SET "VAR_MAIN_PINFO=-1"
)
:main_parseArgument_exit
GOTO :eof

REM //Sub-routine to print menu
:main_printMenu
REM //In:
REM //Out:
ECHO.----------------------------------------------------------------
ECHO.Main Menu:
ECHO.  q - Quit
ECHO.  s - List user index
ECHO.  i - Import user by index
ECHO.  n - Import user by name
ECHO.  f - Import user from file
ECHO.
ECHO.----------------------------------------------------------------
GOTO :eof

REM //Sub-routine to remove a file
REM //In: [file]
REM //Out:
:main_removeFile
IF EXIST "%~1" (
  REM ECHO.remove file "%~1"
  DEL "%~1"
) ELSE (
  REM ECHO.remove file "%~1" not found
)
GOTO :eof

REM //Sub-routine to print user index list
:main_printList
REM //In: [start] [total]
REM //Out:
IF %~2 GTR 0 (
  IF %~1 GTR 0 IF %~1 LEQ %VAR_MAIN_LSTMAX% SET "VAR_MAIN_LSTST=%~1"

  SET /A VAR_MAIN_FLAG=!VAR_MAIN_LSTST!/%VAR_MAIN_PAGE%
  SET /A VAR_MAIN_FLAG+=1
  SET /A VAR_MAIN_LSTEN=%VAR_MAIN_LSTMAX%/%VAR_MAIN_PAGE%
  SET /A VAR_MAIN_LSTEN+=1
  ECHO.
  ECHO.----------------------------------------------------------------
  ECHO.User Index ^(Page !VAR_MAIN_FLAG!/!VAR_MAIN_LSTEN!^)
  ECHO.----------------------------------------------------------------
  REM //List index
  SET "VAR_MAIN_FLAG=0"
  SET /A VAR_MAIN_LSTEN=!VAR_MAIN_LSTST!+%~2
  FOR /F "usebackq tokens=1,2,3,* delims=," %%a IN (`FIND ",idx," "%VAR_MAIN_FILE_LST%" 2^>^&1`) DO (
    IF "%%b"=="idx" (
      SET /A VAR_MAIN_FLAG+=1
      IF !VAR_MAIN_FLAG! GEQ !VAR_MAIN_LSTST! IF !VAR_MAIN_FLAG! LSS !VAR_MAIN_LSTEN! ECHO.%%a^) %%d
    )
  )

  ECHO.----------------------------------------------------------------
  ECHO.Prev^(p^) Next^(n^) Jump^(j^) Back^(b^) Quit^(q^)
  ECHO.----------------------------------------------------------------
)
GOTO :eof

REM //Sub-routine to parse cmd "FIND" return number
:main_findNumber
REM //In: string
REM //Out: VAR_MAIN_RTN_TMP
SET "VAR_MAIN_RTN_TMP=0"
FOR /F "tokens=1,* delims=:" %%i IN ("%~1") DO (
  IF /I "%%j"=="" (
    SET "VAR_MAIN_RTN_TMP=%%i"
    GOTO main_findNumber_Exit
  ) ELSE (
    CALL :main_findNumber "%%j"
  )
)
:main_findNumber_Exit
GOTO :eof

REM //Index----------------------------------------------------------
REM //Sub-routine to initial variables
REM //In:
REM //Out:
:index_initial
REM //User argument
SET "VAR_INDX_FILE_IN=fExport.ldf"
SET "VAR_INDX_FILE_OUT=fExport.idx"
SET "VAR_INDX_VERBOSE=0"
REM //Temp file
SET "VAR_INDX_FILE_IDX=tmp.idx"
REM //Internal data
SET "VAR_INDX_FLAG="
SET "VAR_INDX_STR_FIELD="
SET "VAR_INDX_FLAG_INDEX=0"
SET "VAR_INDX_FLAG_ISINDEX=0"

GOTO :eof

REM //Sub-routine to de-initial variables
REM //In:
REM //Out:
:index_deInitial
SET "VAR_INDX_FILE_IN="
SET "VAR_INDX_FILE_OUT="
SET "VAR_INDX_VERBOSE="
SET "VAR_INDX_FILE_IDX="
SET "VAR_INDX_FLAG="
SET "VAR_INDX_STR_FIELD="
SET "VAR_INDX_FLAG_INDEX=0"
SET "VAR_INDX_FLAG_ISINDEX=0"
GOTO :eof

REM //Sub-routine to create index file
REM //In: [input file] [output file] [verbose]
REM //Out:
:index_main
REM //Create variables
CALL :index_initial

REM //Set input paraments
SET "VAR_INDX_FILE_IN=%~1"
SET "VAR_INDX_FILE_OUT=%~2"
SET "VAR_INDX_VERBOSE=%~3"

REM //Delete existing output file
CALL :main_removeFile "%VAR_INDX_FILE_OUT%"

REM //Create index temp file for all interested AD object fields
FIND /N "dn:" "%VAR_INDX_FILE_IN%" > "%VAR_INDX_FILE_IDX%"
FIND /N "member:" "%VAR_INDX_FILE_IN%" >> "%VAR_INDX_FILE_IDX%"

SET /P "=Scanning."<NUL
REM //Parse index temp file
FOR /F "usebackq tokens=1,2 delims=]" %%i IN ("%VAR_INDX_FILE_IDX%") DO (
  FOR /F "tokens=1 delims=[" %%k IN ("%%i") DO (
    IF NOT "%%j"=="" (
      REM //Pass in a single line number that containing the target username
      CALL :index_scanContent %%k
    )
  )
)

:index_main_exit
REM //Delete temp file
CALL :main_removeFile "%VAR_INDX_FILE_IDX%"

REM //Delete variables
CALL :index_deInitial
GOTO :eof

REM //Sub-routine to parse a complete AD field with lines
REM //In: [lineNum]
REM //Out: [string]
:index_scanContent
SET /A VAR_INDX_FLAG=%~1-1
IF %VAR_INDX_FLAG% LEQ 0 (
 SET "VAR_INDX_FLAG= "
) ELSE (
 SET "VAR_INDX_FLAG=skip=%VAR_INDX_FLAG%"
)
SET "VAR_INDX_STR_FIELD="
SET "VAR_INDX_FLAG_ISINDEX=0"
FOR /F "usebackq %VAR_INDX_FLAG% tokens=* delims=:" %%i IN ("%VAR_INDX_FILE_IN%") DO (
  IF "!VAR_INDX_STR_FIELD!"=="" (
    SET "VAR_INDX_STR_FIELD=%%i"
    FOR /F "tokens=1,* delims=:" %%j IN ("!VAR_INDX_STR_FIELD!") DO IF "%%j"=="dn" SET "VAR_INDX_FLAG_ISINDEX=1"
  ) ELSE (
    SET "VAR_INDX_FLAG=%%i"
    SET "VAR_INDX_FLAG=!VAR_INDX_FLAG:~0,1!"
    IF "!VAR_INDX_FLAG!"==" " (
    REM //Trim leading space and append string
      FOR /F "tokens=1,* delims= " %%j IN ("%%i") DO SET "VAR_INDX_STR_FIELD=!VAR_INDX_STR_FIELD!%%j"
    ) ELSE (
      REM //New attribute or special tag appears, prevous string is completed
      REM IF %VAR_INDX_VERBOSE% GEQ 1 FOR /F "tokens=1,* delims= " %%a IN ("!VAR_INDX_STR_FIELD!") DO ECHO.Marking..."%%b"

      REM //Check Base64 encoded
      CALL :index_isBase64Enc "!VAR_INDX_STR_FIELD!"
      IF !VAR_MAIN_IS_BASE64DEC! GTR 0 (
        FOR /F "tokens=1,* delims= " %%k IN ("!VAR_INDX_STR_FIELD!") DO (
          IF %VAR_INDX_VERBOSE% GEQ 1 ECHO. & ECHO.Decoding..."%%l" & ECHO.
          CALL :base64Dec_main "%%l"
          (ECHO.[%~1]%%k !VAR_MAIN_BASE64DEC!)>>"%VAR_INDX_FILE_OUT%"
          REM //Write index
          IF !VAR_INDX_FLAG_ISINDEX! GTR 0 (
            REM //Search duplicate record
            FOR /F "usebackq tokens=*" %%d IN (`FIND /C ",idx,h,!VAR_MAIN_BASE64DEC!" "%VAR_INDX_FILE_OUT%" 2^>^&1`) DO (
              CALL :main_findNumber "%%d"
              IF !VAR_MAIN_RTN_TMP! LEQ 0 (
                SET /A VAR_INDX_FLAG_INDEX+=1
                (ECHO. !VAR_INDX_FLAG_INDEX!,idx,h,!VAR_MAIN_BASE64DEC!)>>"%VAR_INDX_FILE_OUT%"
              )
            )
          )
        )
      ) ELSE (
        (ECHO.[%~1]!VAR_INDX_STR_FIELD!)>>"%VAR_INDX_FILE_OUT%"
        REM //Write index
        IF !VAR_INDX_FLAG_ISINDEX! GTR 0 (
          REM //Parse '='
          FOR /F "tokens=1,* delims==" %%a IN ("!VAR_INDX_STR_FIELD!") DO (
            REM //Parse ','
            FOR /F "tokens=1 delims=," %%c IN ("%%b") DO (
              REM //Search duplicate record
              FOR /F "usebackq tokens=*" %%d IN (`FIND /C ",idx,a,%%c" "%VAR_INDX_FILE_OUT%" 2^>^&1`) DO (
                CALL :main_findNumber "%%d"
                IF !VAR_MAIN_RTN_TMP! LEQ 0 (
                  SET /A VAR_INDX_FLAG_INDEX+=1
                  (ECHO. !VAR_INDX_FLAG_INDEX!,idx,a,%%c)>>"%VAR_INDX_FILE_OUT%"
                )
              )
            )
          )
        )
      )
      GOTO index_scanContent_exit
    )
  )
)
:index_scanContent_exit
SET /P "=."<NUL
GOTO :eof

REM //Sub-routine to check the input is Base64 encoded
REM //In: [string]
REM //Out: [VAR_MAIN_IS_BASE64DEC]
:index_isBase64Enc
SET "VAR_MAIN_IS_BASE64DEC=0"
FOR /F "tokens=1,* delims= " %%i IN ("%~1") DO (
  SET "VAR_MAIN_IS_BASE64DEC=%%i"
  IF "!VAR_MAIN_IS_BASE64DEC:~-2!"=="::" (
    SET "VAR_MAIN_IS_BASE64DEC=1"
  ) ELSE (
    SET "VAR_MAIN_IS_BASE64DEC=0"
  )
)
GOTO :eof


REM //Base64 Decode----------------------------------------------------------
REM //Sub-routine to initial variables
REM //In:
REM //Out:
:base64Dec_initial
REM //User argument
SET "VAR_B64D_STR_IN=Q0495ZOIIOS9rCxDTj1Vc2VycyxEQz1haHNheXFhLERDPWxvY2Fs"
REM //Temp file
SET "VAR_B64D_FILE_TMP=base64.tmp"
REM //Internal data
SET "VAR_B64D_ARR_D2H=0"
SET "VAR_B64D_NUMCHAR=0"
SET "VAR_B64D_STR_TMP="
SET "VAR_B64D_CODE_DEC="
SET "VAR_B64D_CODE_4BIT="
SET "VAR_B64D_CODE_HEX="
REM //Do not modified the followings
SET "VAR_B64D_MAP_BASE64=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="
SET "VAR_B64D_MAP_HEX=0123456789ABCDEF"
SET "VAR_B64D_CODE_INDEX=1"
SET "VAR_B64D_CODE_BYTE=24"
SET "VAR_B64D_DECODE_INDEX=0"
SET "VAR_B64D_DECODE_REMAIN=0"
SET "VAR_B64D_DECODE_BYTE="
SET "VAR_B64D_DECODE_BYTESTR="
SET "VAR_B64D_DECODE_OFFSET=256"
GOTO :eof

REM //Sub-routine to de-initial variables
REM //In:
REM //Out:
:base64Dec_deInitial
SET "VAR_B64D_STR_IN="
SET "VAR_B64D_FILE_TMP="
SET "VAR_B64D_ARR_D2H="
SET "VAR_B64D_NUMCHAR="
SET "VAR_B64D_STR_TMP="
SET "VAR_B64D_CODE_DEC="
SET "VAR_B64D_CODE_4BIT="
SET "VAR_B64D_CODE_HEX="
SET "VAR_B64D_MAP_BASE64="
SET "VAR_B64D_MAP_HEX="
SET "VAR_B64D_CODE_INDEX="
SET "VAR_B64D_CODE_BYTE="
SET "VAR_B64D_DECODE_INDEX="
SET "VAR_B64D_DECODE_REMAIN="
SET "VAR_B64D_DECODE_BYTE="
SET "VAR_B64D_DECODE_BYTESTR="
SET "VAR_B64D_DECODE_OFFSET="
GOTO :eof

REM //Sub-routine to decode base64 string
REM //In: [string]
REM //Out: [VAR_MAIN_BASE64DEC]
:base64Dec_main
SET "VAR_MAIN_BASE64DEC="
REM //Create variables
CALL :base64Dec_initial

REM //Set input paraments
SET "VAR_B64D_STR_IN=%~1"

REM //Create dec2Hex array map
FOR /L %%i IN (0,1,15) DO (
  SET "VAR_B64D_ARR_D2H%%i=!VAR_B64D_MAP_HEX:~%%i,1!"
)

REM //Count input base64 byte length
(ECHO.%VAR_B64D_STR_IN%)>"%VAR_B64D_FILE_TMP%"
FOR %%i IN (%VAR_B64D_FILE_TMP%) DO (
  SET VAR_B64D_NUMCHAR=%%~zi
  IF %%~zi LSS 4 GOTO base64Dec_main_exit
  SET /A VAR_B64D_NUMCHAR=%%~zi/4
)
CALL :main_removeFile "%VAR_B64D_FILE_TMP%"

REM //Base64 decode
SET "VAR_B64D_STR_TMP=%VAR_B64D_STR_IN%"
FOR /L %%i IN (1,1,%VAR_B64D_NUMCHAR%) DO (
  IF "%VAR_B64D_STR_TMP%"=="" GOTO :base64Dec_main_decodeDone
  IF %%i GTR %VAR_B64D_NUMCHAR% GOTO :base64Dec_main_decodeDone

  SET "VAR_B64D_CODE_INDEX=1"
  FOR /L %%j IN (0,1,3) DO (
    FOR /L %%k IN (0,1,64) DO (
      REM //Search for base64 index
      IF "!VAR_B64D_STR_TMP:~%%j,1!"=="!VAR_B64D_MAP_BASE64:~%%k,1!" (
      SET "VAR_B64D_CODE_BYTE!VAR_B64D_CODE_INDEX!=%%k"
        SET /A VAR_B64D_CODE_INDEX+=1
      )
    )
  )
  REM //Re-pack bytes
  SET /A VAR_B64D_DECODE_BYTE="(VAR_B64D_CODE_BYTE1<<2)|(VAR_B64D_CODE_BYTE2>>4)"
  CALL :base64Dec_dec2hex !VAR_B64D_DECODE_BYTE!
  SET "VAR_B64D_DECODE_BYTESTR=!VAR_B64D_DECODE_BYTESTR!!VAR_B64D_CODE_HEX!"

  SET /A VAR_B64D_DECODE_BYTE="((VAR_B64D_CODE_BYTE2&15)<<4)|(VAR_B64D_CODE_BYTE3>>2)"
  CALL :base64Dec_dec2hex !VAR_B64D_DECODE_BYTE!
  SET "VAR_B64D_DECODE_BYTESTR=!VAR_B64D_DECODE_BYTESTR!!VAR_B64D_CODE_HEX!"

  SET /A VAR_B64D_DECODE_BYTE="((VAR_B64D_CODE_BYTE3&3)<<6)|VAR_B64D_CODE_BYTE4"
  CALL :base64Dec_dec2hex !VAR_B64D_DECODE_BYTE!
  SET "VAR_B64D_DECODE_BYTESTR=!VAR_B64D_DECODE_BYTESTR!!VAR_B64D_CODE_HEX!"

  SET /A VAR_B64D_DECODE_INDEX+=3

  REM //remove decode string
  SET VAR_B64D_STR_TMP=!VAR_B64D_STR_TMP:~4!
)
:base64Dec_main_decodeDone
IF DEFINED VAR_B64D_DECODE_BYTESTR (
  IF %VAR_B64D_CODE_BYTE4% EQU 64 (
    SET /A VAR_B64D_DECODE_INDEX-=1
    SET "VAR_B64D_DECODE_BYTESTR=!VAR_B64D_DECODE_BYTESTR:~0,-3!"
    IF %VAR_B64D_CODE_BYTE3% EQU 64 (
      SET /A VAR_B64D_DECODE_INDEX-=1
      SET "VAR_B64D_DECODE_BYTESTR=!VAR_B64D_DECODE_BYTESTR:~0,-3!"
    )
  )
  CALL :base64Dec_dec2hex %VAR_B64D_DECODE_OFFSET%
  REM //Save result
  SET "VAR_MAIN_BASE64DEC=!VAR_B64D_DECODE_BYTESTR!"
)

REM CALL :base64Dec_dec2hex %VAR_B64D_DECODE_INDEX%

:base64Dec_main_exit
REM //Delete temp file
CALL :main_removeFile "%VAR_B64D_FILE_TMP%"

REM //Delete variables
CALL :base64Dec_deInitial
GOTO :eof

REM //Sub-routine to convert dec to hex
:base64Dec_dec2hex
REM //In: [dec]
REM //Out: [VAR_B64D_CODE_HEX]
SET /A "VAR_B64D_CODE_DEC=%~1"
SET /A "VAR_B64D_CODE_4BIT=0"
SET "VAR_B64D_CODE_HEX="

IF %VAR_B64D_CODE_DEC% EQU 0 (
  SET "VAR_B64D_CODE_HEX=00"
  GOTO :base64Dec_dec2hex_exit
)
IF %VAR_B64D_CODE_DEC% GTR 255 (
  SET "c=4"
) ELSE (
  SET "c=2"
)

FOR /L %%i IN (1,1,%c%) DO (
  SET /A VAR_B64D_CODE_4BIT="VAR_B64D_CODE_DEC&15"
  SET /A VAR_B64D_CODE_DEC="VAR_B64D_CODE_DEC>>4"
  CALL SET VAR_B64D_CODE_HEX=%%VAR_B64D_ARR_D2H!VAR_B64D_CODE_4BIT!%%!VAR_B64D_CODE_HEX!
)
:base64Dec_dec2hex_exit
GOTO :eof


REM //HexDump----------------------------------------------------------
REM //Sub-routine to initial variables
REM //In:
REM //Out:
:hexDump_initial
SET "VAR_HXDP_STRING="
SET "VAR_HXDP_FILE_IN=dBin.asc"
SET "VAR_HXDP_FILE_TMP=dBin.tmp"
SET "VAR_HXDP_BYTE_SIZE=0"
SET "VAR_HXDP_BYTE_OFFSET=0"
SET "VAR_HXDP_BYTE_HEX=0"
SET "VAR_HXDP_BYTE_STREAM="
GOTO :eof

REM //Sub-routine to de-initial variables
REM //In:
REM //Out:
:hexDump_deInitial
SET "VAR_HXDP_STRING="
SET "VAR_HXDP_FILE_IN="
SET "VAR_HXDP_FILE_TMP="
SET "VAR_HXDP_BYTE_SIZE="
SET "VAR_HXDP_BYTE_OFFSET="
SET "VAR_HXDP_BYTE_HEX="
SET "VAR_HXDP_BYTE_STREAM="
GOTO :eof

REM //Sub-routine to convert a string to hex format
REM //In: [string]
REM //Out: [VAR_MAIN_HEXDUMP]
:hexDump_main
REM //Create variables
CALL :hexDump_initial

REM //Set input paraments
SET "VAR_HXDP_STRING=%~1"

(ECHO.%VAR_HXDP_STRING%)>%VAR_HXDP_FILE_IN%

CALL :main_removeFile "%VAR_HXDP_FILE_TMP%"

FOR %%i IN ("%VAR_HXDP_FILE_IN%") do (
  SET /A VAR_HXDP_BYTE_SIZE=%%~zi || GOTO hexDump_main_exit
  IF !VAR_HXDP_BYTE_SIZE! LEQ 0 GOTO hexDump_main_exit
  FSUTIL FILE CREATENEW "%VAR_HXDP_FILE_TMP%" %%~zi >nul || GOTO hexDump_main_exit
)

SET /A VAR_HXDP_BYTE_OFFSET=1
FOR /F "skip=1 tokens=1,2 delims=: " %%i IN ('FC /B "%VAR_HXDP_FILE_IN%" "%VAR_HXDP_FILE_TMP%"') do (
  REM //Terminate if '\n' is found
  IF "%%j"=="0D" GOTO hexDump_main_exit

  SET /A VAR_HXDP_BYTE_HEX=0x%%i
  FOR /L %%k IN (!VAR_HXDP_BYTE_OFFSET! 1 !VAR_HXDP_BYTE_HEX!) DO SET "VAR_HXDP_BYTE_STREAM=!VAR_HXDP_BYTE_STREAM!00"
  SET "VAR_HXDP_BYTE_STREAM=!VAR_HXDP_BYTE_STREAM!%%j"
  SET /A VAR_HXDP_BYTE_OFFSET=VAR_HXDP_BYTE_HEX+2
)
FOR /L %%i IN (!VAR_HXDP_BYTE_OFFSET! 1 !VAR_HXDP_BYTE_SIZE!) DO "VAR_HXDP_BYTE_STREAM=!VAR_HXDP_BYTE_STREAM!00"

:hexDump_main_exit
SET "VAR_MAIN_HEXDUMP=%VAR_HXDP_BYTE_STREAM%"

REM //Delete variables
CALL :main_removeFile "%VAR_HXDP_FILE_IN%"
CALL :main_removeFile "%VAR_HXDP_FILE_TMP%"

CALL :hexDump_deInitial
GOTO :eof


REM //Parser----------------------------------------------------------
REM //Sub-routine to initial variables
REM //In:
REM //Out:
:parser_initial
REM //User argument
SET "VAR_PASE_FILE_IN=fExport.ldf"
SET "VAR_PASE_FILE_IDX=fExport.idx"
SET "VAR_PASE_FILE_OUT=fImport.ldf"
SET "VAR_PASE_USER_ASC="
SET "VAR_PASE_USER_HEX="
SET "VAR_PASE_VERBOSE=0"
REM //Temp file
SET "VAR_PASE_FILE_TMPTAG=parser.tag"
SET "VAR_PASE_FILE_TMPUSR=parser.usr"
REM //Internal data
SET "VAR_PASE_TAG_ACC=dn"
SET "VAR_PASE_RECORD_COPIED=0"
SET "VAR_PASE_FLAG="
GOTO :eof

REM //Sub-routine to de-initial variables
REM //In:
REM //Out:
:parser_deInitial
SET "VAR_PASE_FILE_IN="
SET "VAR_PASE_FILE_IDX="
SET "VAR_PASE_FILE_OUT="
SET "VAR_PASE_USER_ASC="
SET "VAR_PASE_USER_HEX="
SET "VAR_PASE_VERBOSE="
SET "VAR_PASE_FILE_TMPTAG="
SET "VAR_PASE_FILE_TMPUSR="
SET "VAR_PASE_TAG_ACC="
SET "VAR_PASE_RECORD_COPIED="
SET "VAR_PASE_FLAG="
GOTO :eof

REM //Sub-routine to parse and copy a single AD user objects from source file
REM //In: [input file] [index file] [output file] [ASCII name] [HEX name] [verbose]
REM //Out:
:parser_main
REM //Create variables
CALL :parser_initial

REM //Set input paraments
SET "VAR_PASE_FILE_IN=%~1"
SET "VAR_PASE_FILE_IDX=%~2"
SET "VAR_PASE_FILE_OUT=%~3"
SET "VAR_PASE_USER_ASC=%~4"
SET "VAR_PASE_USER_HEX=%~5"
SET "VAR_PASE_VERBOSE=%~6"

SET "VAR_PASE_FLAG=%VAR_PASE_USER_ASC%%VAR_PASE_USER_HEX%"
IF "%VAR_PASE_FLAG%"=="" (
  IF %VAR_PASE_VERBOSE% GEQ 1 ECHO.Username is not defined
  GOTO parser_main_exit
)

REM //Check source file exist
IF NOT EXIST "%VAR_PASE_FILE_IN%" (
  IF %VAR_PASE_VERBOSE% GEQ 1 ECHO.File "%VAR_PASE_FILE_IN%" not found
  GOTO parser_main_exit
)
IF NOT EXIST "%VAR_PASE_FILE_IDX%" (
  IF %VAR_PASE_VERBOSE% GEQ 1 ECHO.File "%VAR_PASE_FILE_IDX%" not found
  GOTO parser_main_exit
)

REM //Check input file data content
SET "VAR_PASE_FLAG=0"
FOR /F "usebackq tokens=*" %%i IN (`FIND /C "%VAR_PASE_TAG_ACC%" "%VAR_PASE_FILE_IN%" 2^>^&1`) DO (
  CALL :main_findNumber "%%i"
  SET "VAR_PASE_FLAG=!VAR_MAIN_RTN_TMP!"
)
IF %VAR_PASE_FLAG% LEQ 0 (
  IF %VAR_PASE_VERBOSE% GEQ 1 ECHO.No record set found in file "%VAR_PASE_FILE_IN%"
  GOTO parser_main_exit
)

REM //Check input file user content
SET "VAR_PASE_FLAG=0"
SET "VAR_PASE_RECORD_TMP=%VAR_PASE_FLAG%"
IF NOT "%VAR_PASE_USER_ASC%"=="" FOR /F "usebackq tokens=*" %%i IN (`FIND /C "%VAR_PASE_USER_ASC%" "%VAR_PASE_FILE_IDX%" 2^>^&1`) DO (
  CALL :main_findNumber "%%i"
  SET "VAR_PASE_RECORD_TMP=!VAR_MAIN_RTN_TMP!"
)
SET "VAR_PASE_FLAG=0"
IF NOT "%VAR_PASE_USER_HEX%"=="" FOR /F "usebackq tokens=*" %%i IN (`FIND /C "%VAR_PASE_USER_HEX%" "%VAR_PASE_FILE_IDX%" 2^>^&1`) DO (
  CALL :main_findNumber "%%i"
  SET "VAR_PASE_FLAG=!VAR_MAIN_RTN_TMP!"
)
SET /A VAR_PASE_RECORD_TMP+=%VAR_PASE_FLAG%
IF %VAR_PASE_RECORD_TMP% LEQ 0 (
  IF %VAR_PASE_VERBOSE% GEQ 1 ECHO.User not found in "%VAR_PASE_FILE_IDX%"
  GOTO parser_main_exit
)

REM //Delete existing output file
CALL :main_removeFile "%VAR_PASE_FILE_OUT%"

REM //Create index temp file (mark the starting line number of each account data)
FIND /N "%VAR_PASE_TAG_ACC%" "%VAR_PASE_FILE_IN%">"%VAR_PASE_FILE_TMPTAG%"

REM //Create index temp file (mark the line number that containing the target username)
ECHO.>"%VAR_PASE_FILE_TMPUSR%"
IF NOT "%VAR_PASE_USER_ASC%"=="" FIND "%VAR_PASE_USER_ASC%" "%VAR_PASE_FILE_IDX%">>"%VAR_PASE_FILE_TMPUSR%"
IF NOT "%VAR_PASE_USER_HEX%"=="" FIND "%VAR_PASE_USER_HEX%" "%VAR_PASE_FILE_IDX%">>"%VAR_PASE_FILE_TMPUSR%"

REM //Parse target account line number from the index temp file content
FOR /F "usebackq tokens=1,2 delims=]" %%i IN ("%VAR_PASE_FILE_TMPUSR%") DO (
  FOR /F "tokens=1 delims=[" %%k IN ("%%i") DO (
    IF NOT "%%j"=="" (
      REM //Pass in a single line number that containing the target username
      CALL :parser_searchContent %%k
    )
  )
)
:parser_main_exit
IF %VAR_PASE_VERBOSE% GEQ 1 ECHO.

REM //Delete temp file
CALL :main_removeFile "%VAR_PASE_FILE_TMPTAG%"
CALL :main_removeFile "%VAR_PASE_FILE_TMPUSR%"

REM //Delete variables
CALL :parser_deInitial
GOTO :eof

REM //Sub-routine to filter out the target user information
REM //In: [lineNum]
REM //Out:
:parser_searchContent
SET /A VAR_PASE_RECORD_TMP=%~1
SET "VAR_PASE_FLAG=0"
:parser_searchContent_find_matchLine_loop
REM //Looking for a starting line number of an account data that containing the target username
FOR /F "usebackq tokens=*" %%i IN (`FIND /C "[%VAR_PASE_RECORD_TMP%]" "%VAR_PASE_FILE_TMPTAG%" 2^>^&1`) DO (
  CALL :main_findNumber "%%i"
  IF !VAR_MAIN_RTN_TMP! GEQ 1 (
   SET "VAR_PASE_FLAG=0"
  ) ELSE (
   SET "VAR_PASE_FLAG=1"
   SET /A VAR_PASE_RECORD_TMP-=1
  )
)

REM //Is the starting line number of an account data valid?
IF %VAR_PASE_RECORD_TMP% LEQ 0 GOTO parser_searchContent_exit

REM //Is the starting line number of an account data found?
IF %VAR_PASE_FLAG% GEQ 1 GOTO parser_searchContent_find_matchLine_loop

REM //Read first line of the target account with offset
SET /A VAR_PASE_FLAG=%VAR_PASE_RECORD_TMP%-1
IF %VAR_PASE_FLAG% LEQ 0 (
  SET "VAR_PASE_FLAG="
) ELSE (
  SET "VAR_PASE_FLAG=skip=%VAR_PASE_FLAG%"
)
FOR /F "usebackq %VAR_PASE_FLAG% tokens=* delims=:" %%i IN ("%VAR_PASE_FILE_IN%") DO (
  (ECHO.%%i)>>"%VAR_PASE_FILE_OUT%"
  IF %VAR_PASE_VERBOSE% GEQ 1 FOR /F "tokens=2 delims=:" %%j IN ("%%i") DO ECHO.Copying entries: %%j
  GOTO parser_searchContent_scan_lines
)

:parser_searchContent_scan_lines
SET /A VAR_PASE_RECORD_COPIED+=1
REM //Read remaining lines of the target account with offset
FOR /F "usebackq skip=%VAR_PASE_RECORD_TMP% tokens=* delims=:" %%i IN ("%VAR_PASE_FILE_IN%") DO (
  FOR /F "tokens=1,2 delims=:" %%j IN ("%%i") DO (
    IF "%%j"=="%VAR_PASE_TAG_ACC%" (
      REM //Found the starting tag of an account data
      REM //We are already moved to the next account data
      GOTO parser_searchContent_exit
    )
    REM //Need filter before write to output file?
    IF "%%j"=="userAccountControl" (
      REM //Because LDIFDE does not export passwords, 
      REM //when the users are imported into the directory,
      REM //the account is disabled and the password is set to null.
      REM //This is done for security reasons.
      REM //Also, the account option "User must change password at next logon" is selected.
	  REM //Therefore, just skip to set this attribute and keep its default value
    ) ELSE (
      (ECHO.%%i)>>"%VAR_PASE_FILE_OUT%"
    )
  )
)
:parser_searchContent_exit
REM //write a newline before parser_main_exit
ECHO.>>"%VAR_PASE_FILE_OUT%"
GOTO :eof


REM //Import Single User----------------------------------------------------------
REM //Sub-routine to initial variables
REM //In:
REM //Out:
:importUsr_initial
REM //User argument
SET "VAR_IMPU_FILE_IN=fExport.ldf"
SET "VAR_IMPU_FILE_IDX=fExport.idx"
SET "VAR_IMPU_USER_ASC="
SET "VAR_IMPU_USER_HEX="
SET "VAR_IMPU_HOSTNAME="
SET "VAR_IMPU_VERBOSE=0"
REM //Temp file
SET "VAR_IMPU_FILE_ERR=ldif.err"
SET "VAR_IMPU_FILE_LOG=ldif.log"
SET "VAR_IMPU_FILE_USER=.usr"
SET "VAR_IMPU_FILE_ABS=.abs"
SET "VAR_IMPU_FILE_EER=.err"
SET "VAR_IMPU_FILE_DEC=tmp.dec"
SET "VAR_IMPU_FILE_ADD=tmp.add"
REM //Internal data
SET "VAR_IMPU_USER_ASCFL="
SET "VAR_IMPU_USER_HEXFL="
SET "VAR_IMPU_FLAG="
SET "VAR_IMPU_FLAG_RECORD=0"
SET "VAR_IMPU_STR_FIELD="
GOTO :eof

REM //Sub-routine to de-initial variables
REM //In:
REM //Out:
:importUsr_deInitial
SET "VAR_IMPU_FILE_IN="
SET "VAR_IMPU_FILE_IDX="
SET "VAR_IMPU_USER_ASC="
SET "VAR_IMPU_USER_HEX="
SET "VAR_IMPU_HOSTNAME="
SET "VAR_IMPU_VERBOSE="
SET "VAR_IMPU_FILE_ERR="
SET "VAR_IMPU_FILE_LOG="
SET "VAR_IMPU_FILE_USER="
SET "VAR_IMPU_FILE_ABS="
SET "VAR_IMPU_FILE_EER="
SET "VAR_IMPU_FILE_DEC="
SET "VAR_IMPU_FILE_ADD="
SET "VAR_IMPU_USER_ASCFL="
SET "VAR_IMPU_USER_HEXFL="
SET "VAR_IMPU_FLAG="
SET "VAR_IMPU_FLAG_RECORD="
SET "VAR_IMPU_STR_FIELD="
GOTO :eof

REM //Sub-routine to parse and import a single user AD objects to AD from source file
REM //In: [input file] [index file] [ASCII user] [HEX user] [hostname] [verbose]
REM //Out:
:importUsr_main
REM //Create variables
CALL :importUsr_initial

REM //Set input paraments
SET "VAR_IMPU_FILE_IN=%~1"
SET "VAR_IMPU_FILE_IDX=%~2"
SET "VAR_IMPU_USER_ASC=%~3"
SET "VAR_IMPU_USER_HEX=%~4"
SET "VAR_IMPU_HOSTNAME=%~5"
SET "VAR_IMPU_VERBOSE=%~6"

IF NOT "%VAR_IMPU_USER_HEX%"=="" (
  REM //HEX name is defined, clear ASCII name
  REM //and assume it is already full AD name
  SET "VAR_IMPU_USER_ASC="
) ELSE (  
  REM //No HEX name is defined, convert ASCII name to HEX format
  REM //and assume it is not a full AD name
  CALL :importUsr_userAsc2Hex "%VAR_IMPU_USER_ASC%"
)

REM //Check config
IF NOT EXIST "%VAR_IMPU_FILE_IN%" (
  ECHO.File "%VAR_IMPU_FILE_IN%" not found...
  ECHO.Process terminated...
  GOTO importUsr_main_exit
)
IF NOT EXIST "%VAR_IMPU_FILE_IDX%" (
  ECHO.File "%VAR_IMPU_FILE_IDX%" not found...
  ECHO.Process terminated...
  GOTO importUsr_main_exit
)

REM //Append search maker only if ASCII name is given
REM //If HEX name is given, assume it is already containing the search maker 
IF NOT "%VAR_IMPU_USER_ASC%"=="" (
  SET "VAR_IMPU_USER_ASC=CN=%VAR_IMPU_USER_ASC%,"
  SET "VAR_IMPU_USER_HEX=434E3D%VAR_IMPU_USER_HEX%2C"
)

REM //Get the full user account name from index file
REM //ASCII type
SET "VAR_IMPU_USER_ASCFL="
IF NOT "%VAR_IMPU_USER_ASC%"=="" (
  FOR /F "usebackq tokens=1,* delims=::" %%i IN (`FIND "%VAR_IMPU_USER_ASC%" "%VAR_IMPU_FILE_IDX%" 2^>^&1`) DO (
    IF "!VAR_IMPU_USER_ASCFL!"=="" IF NOT "%%j"=="" FOR /F "tokens=* delims=:" %%k IN ("%%j") DO (
      FOR /F "tokens=* delims= " %%l IN ("%%k") DO SET "VAR_IMPU_USER_ASCFL=%%l"
    )
  )
)
REM //HEX type
SET "VAR_IMPU_USER_HEXFL="
IF NOT "%VAR_IMPU_USER_HEX%"=="" (
  FOR /F "usebackq tokens=1,* delims=::" %%i IN (`FIND "%VAR_IMPU_USER_HEX%" "%VAR_IMPU_FILE_IDX%" 2^>^&1`) DO (
    IF "!VAR_IMPU_USER_HEXFL!"=="" IF NOT "%%j"=="" FOR /F "tokens=* delims=:" %%k IN ("%%j") DO (
      FOR /F "tokens=* delims= " %%l IN ("%%k") DO SET "VAR_IMPU_USER_HEXFL=%%l"
    )
  )
)

REM //Check name
SET "VAR_IMPU_FLAG=%VAR_IMPU_USER_ASCFL%%VAR_IMPU_USER_HEXFL%"
IF "%VAR_IMPU_FLAG%"=="" (
  ECHO.User not found
  GOTO importUsr_main_exit
)

REM //Parse and import AD data set
ECHO.>"%VAR_IMPU_FILE_ADD%"
SET "VAR_IMPU_FLAG_RECORD=1"
CALL :importUsr_parseImport "%VAR_IMPU_USER_ASCFL%" "%VAR_IMPU_USER_HEXFL%" "%VAR_IMPU_FLAG_RECORD%"

:importUsr_main_exit
REM //Delete temp file
CALL :main_removeFile "%VAR_IMPU_FILE_LOG%"
CALL :main_removeFile "%VAR_IMPU_FILE_DEC%"
CALL :main_removeFile "%VAR_IMPU_FILE_ADD%"

REM //Delete variables
CALL :importUsr_deInitial
GOTO :eof

REM //Sub-routine to prepare and import 1 set of user data to AD (recursive routine)
REM //In: [userASCII] [userHEX] [recordNum]
REM //Out:
REM // importUsr_parseImport -> importUsr_missObject -> importUsr_missObjProc -|
REM //   /|\                                                |
REM //    |------------------- recursive -------------------|
:importUsr_parseImport
REM //Parse target user information
IF NOT "%~1"=="" (
  ECHO.^>^>^> Preparing "%~1" directory objects...
) ELSE (
  ECHO.^>^>^> Preparing "%~2" directory objects...
)
ECHO.
IF NOT "%~1"=="" (
  ECHO.%~1>>"%VAR_IMPU_FILE_ADD%"
)
IF NOT "%~2"=="" (
  ECHO.%~2>>"%VAR_IMPU_FILE_ADD%"
)
CALL :parser_main "%VAR_IMPU_FILE_IN%" "%VAR_IMPU_FILE_IDX%" "%~3%VAR_IMPU_FILE_USER%" "%~1" "%~2" %VAR_IMPU_VERBOSE%

REM //Import data to AD
SET "VAR_IMPU_FLAG=1"
IF %VAR_IMPU_VERBOSE% GEQ 1 SET "VAR_IMPU_FLAG=2"

CALL %VAR_MAIN_EXEC_IMPORT% info:0 verbose:%VAR_IMPU_FLAG% "fin:%~3%VAR_IMPU_FILE_USER%" "hostname:%VAR_IMPU_HOSTNAME%"
ECHO.

REM //Check is error log
SET "VAR_IMPU_FLAG=0"
IF NOT EXIST "%VAR_IMPU_FILE_ERR%" GOTO importUsr_parseImport_exit
REM //Rename to avoid overwrite by recursive call
IF EXIST "%~3%VAR_IMPU_FILE_EER%" CALL :main_removeFile "%~3%VAR_IMPU_FILE_EER%"
REN "%VAR_IMPU_FILE_ERR%" "%~3%VAR_IMPU_FILE_EER%"

REM //Create error temp file
FIND "Object does not exist" "%~3%VAR_IMPU_FILE_EER%" > "%~3%VAR_IMPU_FILE_ABS%"
FOR /F "usebackq tokens=1,2 delims=:" %%i IN ("%~3%VAR_IMPU_FILE_ABS%") DO (
  IF NOT "%%j"=="" (
    REM //Pass in a single line number that containing error
	CALL :importUsr_missObject "%%i" "%~3%VAR_IMPU_FILE_USER%" "%~1" "%~2" "%~3"
  )
)
REM //Check any import error
SET "VAR_IMPU_FLAG=0"
FOR /F "usebackq tokens=*" %%i IN (`FIND /C "error" "%~3%VAR_IMPU_FILE_EER%" 2^>^&1`) DO (
  CALL :main_findNumber "%%i"
  IF !VAR_MAIN_RTN_TMP! GEQ 1 SET "VAR_IMPU_FLAG=1"
)
:importUsr_parseImport_exit
REM //Remove import log files only if no error occur
IF %VAR_IMPU_FLAG% LEQ 0 (
  CALL :main_removeFile "%~3%VAR_IMPU_FILE_EER%"
  CALL :main_removeFile "%~3%VAR_IMPU_FILE_USER%"
)
REM //remove user temp file
CALL :main_removeFile "%~3%VAR_IMPU_FILE_ABS%"
GOTO :eof

REM //Sub-routine to handle any missing user object (recursive routine)
REM //In: [lineNum] [file] [userASCII] [userHEX] [recordNum]
REM //Out:
:importUsr_missObject
SET /A VAR_IMPU_FLAG=%~1-1
REM //Error if pass in "skip=0" to command FOR
IF %VAR_IMPU_FLAG% LEQ 0 (
  SET "VAR_IMPU_FLAG="
) ELSE (
  SET "VAR_IMPU_FLAG=skip=%VAR_IMPU_FLAG%"
)
SET "VAR_IMPU_STR_FIELD="
FOR /F "usebackq %VAR_IMPU_FLAG% tokens=* delims=:" %%i IN ("%~2") DO (
  REM //Parse a complete AD field with lines
  IF "!VAR_IMPU_STR_FIELD!"=="" (
    SET "VAR_IMPU_STR_FIELD=%%i"
  ) ELSE (
    SET "VAR_IMPU_FLAG=%%i"
    SET "VAR_IMPU_FLAG=!VAR_IMPU_FLAG:~0,1!"
    IF "!VAR_IMPU_FLAG!"==" " (
      REM //Trim leading space and append string
      FOR /F "tokens=1,* delims= " %%j IN ("%%i") DO SET "VAR_IMPU_STR_FIELD=!VAR_IMPU_STR_FIELD!%%j"
    ) ELSE (
      REM //New attribute or special tag appears, prevous string is completed
	  CALL :importUsr_missObjProc "!VAR_IMPU_STR_FIELD!" "%~3" "%~4" "%~5"
      GOTO importUsr_missObject_exit
    )
  )
)
:importUsr_missObject_exit
GOTO :eof

REM //Sub-routine to parse username from AD content (recursive routine)
REM //In: [missing user record] [userASCII] [userHEX] [recordNum]
REM //Out:
:importUsr_missObjProc
CALL :index_isBase64Enc "%~1"
IF !VAR_MAIN_IS_BASE64DEC! GTR 0 (
  FOR /F "tokens=1,* delims=: " %%i IN ("%~1") DO (
    CALL :base64Dec_main "%%j"
    REM //Check username already imported in previous process
    FOR /F "usebackq tokens=*" %%x IN (`FIND /C "!VAR_MAIN_BASE64DEC!" "%VAR_IMPU_FILE_ADD%" 2^>^&1`) DO (
      CALL :main_findNumber "%%x"
      IF !VAR_MAIN_RTN_TMP! GTR 0 GOTO importUsr_missObjProc_exit
    )
    IF NOT "!VAR_MAIN_BASE64DEC!"=="%~3" (
      SET /A VAR_IMPU_FLAG_RECORD+=1
      CALL :importUsr_parseImport "" "!VAR_MAIN_BASE64DEC!" "!VAR_IMPU_FLAG_RECORD!"
    ) ELSE (
      REM //Missing member, need special handle, just ignore it
    )
  )
) ELSE (
  FOR /F "tokens=2 delims=:" %%i IN ("%~1") DO (
    FOR /F "tokens=* delims= " %%j IN ("%%i") DO (
      REM //Check username already imported in previous process
      FOR /F "usebackq tokens=*" %%x IN (`FIND /C "%%j" "%VAR_IMPU_FILE_ADD%" 2^>^&1`) DO (
        CALL :main_findNumber "%%x"
        IF !VAR_MAIN_RTN_TMP! GTR 0 GOTO importUsr_missObjProc_exit
      )
      IF NOT "%%j"=="%~2" (
	      SET /A VAR_IMPU_FLAG_RECORD+=1
        REM //Convert username to hex format
        SET "VAR_IMPU_USER_HEX="
        CALL :importUsr_userAsc2Hex "%%j"
	      CALL :importUsr_parseImport "%%j" "!VAR_IMPU_USER_HEX!" "!VAR_IMPU_FLAG_RECORD!"
	    ) ELSE (
	      REM //Missing member, need special handle, just ignore it
      )
    )
  )
)
:importUsr_missObjProc_exit
GOTO :eof

REM //Sub-routine to dump hex from input
REM //In: [string]
REM //Out: [VAR_IMPU_USER_HEX]
:importUsr_userAsc2Hex
CALL :hexDump_main "%~1"
SET "VAR_IMPU_USER_HEX=!VAR_MAIN_HEXDUMP!"
GOTO :eof