/**
 * Parse query string from the URL.
 */
var QueryString = function () {
	// This function is anonymous, is executed immediately and 
	// the return value is assigned to QueryString!
	var query_string = {};
	var query = window.location.search.substring(1);
	var vars = query.split("&");
	for (var i=0;i<vars.length;i++) {
	var pair = vars[i].split("=");
		// If first entry with this name
	if (typeof query_string[pair[0]] === "undefined") {
	  query_string[pair[0]] = decodeURIComponent(pair[1]);
		// If second entry with this name
	} else if (typeof query_string[pair[0]] === "string") {
	  var arr = [ query_string[pair[0]],decodeURIComponent(pair[1]) ];
	  query_string[pair[0]] = arr;
		// If third or later entry with this name
	} else {
	  query_string[pair[0]].push(decodeURIComponent(pair[1]));
	}
	} 
	return query_string;
}();

/**
 * Fill and show/hide the blocks in the page with the supplied application info.
 *
 * For tag with id of "product_name", it will check for the attribute "show" or "hide". Products name specified in the attribute will be show/hide accordingly.
 * For other tags, it will try to match the tag's id the keys provided and replace the content in the tag with the value of the key. 
 *
 * Application info will be cached into _appInfo for refreshing the page if necessary.
 *
 */

// [Start] 12744: 2015-12-15 (sunny.pan) Support loading of included contents
// Application info cache
var _appInfo = null;
// Flag to indicate the included contents are loaded
var _contentsLoaded = true;

// 12775: 2017-09-04 (tony.kung) Store color for loading include page
// Section color cache
var _sectionColor = "";

var refreshHelpPage = function() {
	replacePage(_appInfo);
};

var replacePage = function(appInfo) {
	if (typeof appInfo === "undefined" || appInfo == null)
		return;
	// Set the document body to invisible to avoid user to see the original contents
	document.body.style.display = 'none';
	for(var key in appInfo) {
		// Use class attribute for multiple elements
		var keyTags = document.getElementsByClassName(key);
		for (var i = 0; i < keyTags.length; i++) {
			// For product name, toggle to show/hide the blocks specified by the show/hide attribute
			if (key == "app_name") {
				var keyTag = keyTags[i];
				var product = appInfo[key];
				var showing = keyTag.getAttribute("show");
				if (showing != null && showing != "") {
					// Only products specified in the attribute will be shown
					var showList = showing.split(" ");
					if (showList.indexOf(product) == -1) {
						keyTag.style.display = 'none';
					}
				}
				var hiding = keyTag.getAttribute("hide");
				if (hiding != null && hiding != "") {
					// Products specified in the attribute will be hidden
					var hideList = hiding.split(" ");
					if (hideList.indexOf(product) != -1) {
						keyTag.style.display = 'none';
					}
				}
			}
		}
		// Fill replacement value
		var re = new RegExp("%"+key+"%","g");
		//var bodyHTML = convertToUnicode(document.body.innerHTML);
		document.body.innerHTML = document.body.innerHTML.replace(re, appInfo[key]);
	}
	document.body.style.display = 'block';
	updateSectionColor();
};

var loadHelpPage = function(appInfo) {
	if (typeof appInfo === "undefined" || appInfo == null)
		return;
	_appInfo = appInfo;
	// Check if the included contents are loaded, do replace if loaded otherwise reload the page
	if (_contentsLoaded) {
		refreshHelpPage();
	} else {
		location.reload();
	}
};

/*
 * Helper function to load include contents in cascade style and do replace when all contents are loaded
 * [{"target":"#domID1", "src":"link"}, {"target":"#domID2", "src":"link2"}...]
 */
var includeContents = function(contents) {
	if (!window.jQuery || typeof contents === "undefined" || !Array.isArray(contents) || contents.length == 0)
		return;
	_contentsLoaded = false;
	// Set the document body to invisible to avoid user to see the original contents
	document.body.style.display = 'none';
	// Load include pages in cascade style
	var loadContent = function(index) {
		if (index >= contents.length) {
			_contentsLoaded = true;
			refreshHelpPage();
			document.body.style.display = 'block';
		} else {
			$(contents[index].target).load(contents[index].src, function() {
				loadContent(index+1);
			});
		}
	}
	loadContent(0);
};
// [End] 12744: 2015-12-15 (sunny.pan)

// [Start] 12775: 2017-09-04 (tony.kung) Support customize help page title color
var setSectionColor = function(sectionColor) {
	if (typeof sectionColor === "undefined" || sectionColor == null)
		return;
	_sectionColor = sectionColor;
	updateSectionColor();
};

var updateSectionColor = function() {
	var elem = document.getElementsByTagName('h1');
	for(i = 0; i < elem.length; i++) {
		elem[i].style.color = _sectionColor;
	}
};
// [End] 12775