@ECHO OFF
SETLOCAL enabledelayedexpansion

SET AUA_HOME=%CD%
SET AUA_JVM_DIR=%AUA_HOME%\jvm
SET AUA_JVM_BIN_DIR=%AUA_JVM_DIR%\bin

CD ".."
SET APP_HOME=%CD%
SET UTIL_BIN_HOME=%AUA_HOME%\util\bin

SET FILENAME_JAVA_EXEC_JAVAW=javaw.exe

SET FILENAME_AUA_XML_VERSION=version.xml
SET FILENAME_APP_TXT_VERSION=version.txt

SET FILENAME_APP_EXEC_SERVICE=bJW.exe
SET FILENAME_APP_EXEC_SCHEDULER_SERVICE=bschJW.exe

SET FILENAME_UTIL_7Z=7za.exe

:CHECK_JVM_UPDATE_PATCH_EXIST
SET VERSION=
REM Loop through all directories in the specified path
for /d %%F in ("%AUA_HOME%\*") do (
    REM Check if the folder name matches the version format
    echo|set /p="%%~nxF" | findstr /R "^[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*$" >nul
    if not errorlevel 1 (
        set "currentVersion=%%~nxF"
        if "!VERSION!"=="" (
            set "VERSION=!currentVersion!"
        ) else (
            REM multiply large number to handle version like 1.1.1.300 so it won't be larger than 1.1.2.1
            for /f "tokens=1-4 delims=." %%a in ("!VERSION!") do (
                set /a "v1=%%a*1000000+%%b*10000+%%c*100+%%d"
            )
            for /f "tokens=1-4 delims=." %%a in ("!currentVersion!") do (
                set /a "c1=%%a*1000000+%%b*10000+%%c*100+%%d"
            )
            if !c1! gtr !v1! (
                set "VERSION=!currentVersion!"
            )
        )
    )
)
IF "%VERSION%"=="" (
    ECHO Cannot find version folder from %AUA_HOME% ... 
    EXIT /b 1
)

SET JVM_FILE_HOME=%AUA_HOME%\%VERSION%\upgrade

SET FILENAME_JVM_UPDATE_PATCH=%JVM_FILE_HOME%\jre-std-windows-x64.7z

IF NOT EXIST "%FILENAME_JVM_UPDATE_PATCH%" (
    ECHO Cannot copy because JVM update patch "%FILENAME_JVM_UPDATE_PATCH%" doesn't exist... 
    EXIT /b 2
)
:COPY_JVM_UPDATE_PATCH_TO_AUA_JVM
ECHO Update patch "%FILENAME_JVM_UPDATE_PATCH%" found. Extract the new JVM to aua/jvm... 
IF EXIST "%AUA_JVM_DIR%" (
    ECHO Remove the AUA JVM directory "%AUA_JVM_DIR%" ... 
    RMDIR /S /Q "%AUA_JVM_DIR%"
)

ECHO Extract the new JVM to aua/jvm... 
"%UTIL_BIN_HOME%\%FILENAME_UTIL_7Z%" x "%FILENAME_JVM_UPDATE_PATCH%" -aoa -o"%AUA_JVM_DIR%"

ECHO Config the new JVM ... 
ECHO Create the AUA Service Executable files by copying from the original java executables... 
IF EXIST "%AUA_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" (
    ECHO Copy "%AUA_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" to "%AUA_JVM_BIN_DIR%\%FILENAME_APP_EXEC_SERVICE%" ... 
    COPY "%AUA_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" "%AUA_JVM_BIN_DIR%\%FILENAME_APP_EXEC_SERVICE%" /Y

    ECHO Copy "%AUA_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" to "%AUA_JVM_BIN_DIR%\%FILENAME_APP_EXEC_SCHEDULER_SERVICE%" ... 
    COPY "%AUA_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" "%AUA_JVM_BIN_DIR%\%FILENAME_APP_EXEC_SCHEDULER_SERVICE%" /Y
)

:SCRIPT_END
EXIT /b 0

@ECHO ON